
#pragma used+
sfrb ADCSRB=0x03;
sfrb ADCL=0x04;
sfrb ADCH=0x05;
sfrw ADCW=0x04; 
sfrb ADCSRA=0x06;
sfrb ADMUX=0x07;
sfrb ACSR=0x08;
sfrb DIDR0=0x14;
sfrb PCMSK=0x15;
sfrb PINB=0x16;
sfrb DDRB=0x17;
sfrb PORTB=0x18;
sfrb EECR=0x1c;
sfrb EEDR=0x1d;
sfrb EEAR=0x1e;
sfrb WDTCR=0x21;
sfrb CLKPR=0x26;
sfrb GTCCR=0x28;
sfrb OCR0B=0x29;
sfrb DWDR=0x2e;
sfrb TCCR0A=0x2f;
sfrb OSCCAL=0x31;
sfrb TCNT0=0x32;
sfrb TCCR0B=0x33;
sfrb MCUSR=0x34;
sfrb MCUCR=0x35;
sfrb OCR0A=0x36;
sfrb SPMCSR=0x37;
sfrb TIFR0=0x38;
sfrb TIMSK0=0x39;
sfrb GIFR=0x3a;
sfrb GIMSK=0x3b;
sfrb SPL=0x3d;
sfrb SREG=0x3f;
#pragma used-

#asm
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x18
	.EQU __sm_adc_noise_red=0x08
	.EQU __sm_powerdown=0x10
	.SET power_ctrl_reg=mcucr
	#endif
#endasm

#pragma used+

void delay_us(unsigned int n);
void delay_ms(unsigned int n);

#pragma used-

extern void stx_char(unsigned char value);

int IR_BTemp; 
char TOV_Count; 

char Lo_Ref; 
char Hi_Ref; 
char CNT; 
char Frame_Pos; 

bit F_Key_Pressed;
bit F_Data_Out = 0;

char Get_CNT(){
char CurCNT = CNT;
CNT = 0;
#asm("WDR")
return CurCNT;
}

void Key_Down(){
F_Key_Pressed = 1;
PORTB.3 = 1; 
TOV_Count = 0;        
}

void Key_Up(){
F_Key_Pressed = 0;
PORTB.3 = 0;

}

interrupt [2] void ext_int0_isr(void)
{
char CurCNT = Get_CNT(); 
if (Frame_Pos == 255)
{ 
IR_BTemp = IR_BTemp<<1;
if (CurCNT > Hi_Ref | CurCNT < Lo_Ref) 
IR_BTemp |= 1;
}else if (Frame_Pos == 4) { 

Hi_Ref = CurCNT + 2; 
Lo_Ref = CurCNT - 2; 
Frame_Pos = 255;
IR_BTemp = 0; 

}else if (Frame_Pos == 0) { 
Key_Down();
Frame_Pos = 1;            
}else if (Frame_Pos < 4){ 
Frame_Pos++;            
}
}

interrupt [7] void timer0_compa_isr(void)
{
CNT++;  
}

interrupt [9] void wdt_timeout_isr(void)
{
WDTCR=0x48;

if (F_Key_Pressed != 0){
TOV_Count++;
if (TOV_Count >= 10)
Key_Up(); 

if (Frame_Pos != 0){

Frame_Pos = 0;
PORTB.3 = 0; 
F_Data_Out = 1;
}            
}
}

void main(void){

PORTB=0x00;
DDRB=0x18;

TCCR0A=0x00;
TCCR0B=0x02;
TCNT0=0x00;
OCR0A=0x7C;
OCR0B=0x00;

GIMSK=0x40;
MCUCR=0x02;
GIFR=0x40;

TIMSK0=0x04;

#pragma optsize-
WDTCR=0x18;
WDTCR=0xC8;
#pragma optsize+

{PORTB |=  (1<<4);                             DDRB  |= (1<<4);}; 

Frame_Pos = 0;
TOV_Count = 0;

#asm("sei")
PORTB.3 = 1;
delay_ms(120);
PORTB.3 = 0;

stx_char('O');
stx_char('K');
stx_char('!');
while(1)
{
if (F_Data_Out == 0)
continue;

stx_char('*');
stx_char(IR_BTemp>>8);
stx_char(IR_BTemp);
F_Data_Out = 0;
}
}
