#include "config.h"
#include "stx.h"
#include "delay.h"

#define LED PORTB.3
int IR_BTemp; //  ""
char TOV_Count; //  ( < 10   , 10 -    )
//char Rep_Count; //    (   )

char Lo_Ref; // ""
char Hi_Ref; // ""
char CNT; //   Timer0.   IR 
char Frame_Pos; //   

bit F_Key_Pressed;
bit F_Data_Out = 0;

char Get_CNT(){
    char CurCNT = CNT;
    CNT = 0;
    #asm("WDR")
    return CurCNT;
}

void Key_Down(){
    F_Key_Pressed = 1;
    LED = 1; // 
    TOV_Count = 0;        
}

void Key_Up(){
    F_Key_Pressed = 0;
    LED = 0;
    //Rep_Count = 0;
}

// External Interrupt 0 service routine
interrupt [EXT_INT0] void ext_int0_isr(void)
{
    char CurCNT = Get_CNT(); //  
    if (Frame_Pos == 255)
    { //   
        IR_BTemp = IR_BTemp<<1;
        if (CurCNT > Hi_Ref | CurCNT < Lo_Ref) //    - "1"
            IR_BTemp |= 1;
    }else if (Frame_Pos == 4) { //  
        //  
        Hi_Ref = CurCNT + 2; //  
        Lo_Ref = CurCNT - 2; //  
        Frame_Pos = 255;
        IR_BTemp = 0; //!!!  
        //   
    }else if (Frame_Pos == 0) { // 0_START PILOT
        Key_Down();
        Frame_Pos = 1;            
    }else if (Frame_Pos < 4){ // 1,2,3_
        Frame_Pos++;            
    }
}

// Timer 0 output compare A interrupt service routine
interrupt [TIM0_COMPA] void timer0_compa_isr(void)
{
    CNT++;  //   
}

// Watchdog timeout interrupt service routine
interrupt [WDT] void wdt_timeout_isr(void)
{
    WDTCR=0x48;
    
    if (F_Key_Pressed != 0){
        TOV_Count++;
        if (TOV_Count >= 10)
            Key_Up(); //    (  )
        
        if (Frame_Pos != 0){
            //  
            //   
            Frame_Pos = 0;
            LED = 0; //  
            F_Data_Out = 1;
        }            
    }
}

// Declare your global variables here

void main(void){
// Input/Output Ports initialization
// Port B initialization
// Func5=In Func4=Out Func3=Out Func2=In Func1=In Func0=In 
// State5=T State4=0 State3=0 State2=T State1=T State0=T 
PORTB=0x00;
DDRB=0x18;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 1200,000 kHz
// Mode: Normal top=FFh
// OC0A output: Disconnected
// OC0B output: Disconnected
TCCR0A=0x00;
TCCR0B=0x02;
TCNT0=0x00;
OCR0A=0x7C;
OCR0B=0x00;

// External Interrupt(s) initialization
// INT0: On
// INT0 Mode: Falling Edge
// Interrupt on any change on pins PCINT0-5: Off
GIMSK=0x40;
MCUCR=0x02;
GIFR=0x40;

// Timer/Counter 0 Interrupt(s) initialization
TIMSK0=0x04;

// Watchdog Timer initialization
// Watchdog Timer Prescaler: OSC/2k
// Watchdog Timer interrupt: On
#pragma optsize-
WDTCR=0x18;
WDTCR=0xC8;
#ifdef _OPTIMIZE_SIZE_
#pragma optsize+
#endif

stx_init(); //  UART'

Frame_Pos = 0;
TOV_Count = 0;

// Global enable interrupts
#asm("sei")
LED = 1;
delay_ms(120);
LED = 0;

stx_char('O');
stx_char('K');
stx_char('!');
while(1)
    {
        if (F_Data_Out == 0)
            continue;
                
        stx_char('*');
        stx_char(IR_BTemp>>8);
        stx_char(IR_BTemp);
        F_Data_Out = 0;
    }
}