/**
  Simple TX -       RS-232

  : IAR,CodeVisionAVR.

  http://andryg.sumy.ua/stx/
  max_wer@ukr.net
  $Rev: 71 $

   : 8 ,   ,  .
      :
    - STX_BAUDRATE  -   (9600 115200  ..)
    - STX_PORT_NAME -  ,     (A,B,C...)
    - STX_PIN       -  ,      (0..7)
     ( IAR)   F_CPU -    

  void stx_init()                    -     (  )
  void stx_char(unsigned char value) -  
*/
#ifndef __STX_H
#define __STX_H

#include "config.h"

/*     */
#ifdef __ICCAVR__           /* IAR */
  #ifndef F_CPU
    #error    F_CPU -    
  #endif
  #define stx_delay(x)      __delay_cycles(F_CPU/STX_BAUDRATE - x)
#endif

#ifdef __CODEVISIONAVR__    /* CODEVISION*/
  #include <delay.h>
  #define stx_delay(x)      delay_us(1000000/STX_BAUDRATE - x/(_MCU_CLOCK_FREQUENCY_/1000000))
#endif

/*      */
#ifndef STX_PORT_NAME
#error    STX_PORT_NAME  __  (A,B...)
#endif

#ifndef STX_PIN
#error    STX_PIN   
#endif

#ifndef STX_BAUDRATE
#error    STX_BAUDRATE ( )
#endif

/*          */
#define STX_CONCAT(a,b)     a ## b
#define STX_CONCAT_EX(a,b)  STX_CONCAT(a,b)
#define stx_pin_on()        STX_CONCAT_EX(PORT,STX_PORT_NAME) |=  (1<<STX_PIN)
#define stx_pin_off()       STX_CONCAT_EX(PORT,STX_PORT_NAME) &= ~(1<<STX_PIN)

#define stx_init()          {stx_pin_on();\
                             STX_CONCAT_EX(DDR,STX_PORT_NAME)  |= (1<<STX_PIN);}

extern void stx_char(unsigned char value);
#endif
