unit hiBASS_FFT_2048_Vis;

interface

uses Windows,Kol,Share,Debug,Bass;

type
  THIBASS_FFT_2048_Vis = class(TDebug)
   private
    FreqSeparation: Array[0..743] of integer;
    _Count:integer;
   public
    _prop_SoundStream:^cardinal;
    _prop_IndexMin:integer;
    _prop_IndexMax:integer;
    _data_IndexMin:THI_Event;
    _data_IndexMax:THI_Event;
    _event_onIndFreq:THI_Event;
    _event_onAmpl:THI_Event;

    procedure _work_doFFT(var _Data:TData; Index:word);
    procedure _work_doStrFreqSeparation(var _Data:TData; Index:word);
    procedure _work_doFftVis(var _Data:TData; Index:word);
  end;

implementation

 Type TFFTData  = array [0..1024] of Single;

procedure THIBASS_FFT_2048_Vis._work_doFFT;
var i,_Index,_IndexMin,_IndexMax:integer;
    h:cardinal;
    FFTData:TFFTData;
begin
  h := _prop_SoundStream^;
  if BASS_ChannelIsActive(h) <> BASS_ACTIVE_PLAYING then Exit;
  
  _Index := ToInteger(_Data);
  _IndexMin := ReadInteger(_Data, _data_IndexMin, _prop_IndexMin);
  _IndexMax := ReadInteger(_Data, _data_IndexMax, _prop_IndexMax);
  BASS_ChannelGetData(h, @FFTData, BASS_DATA_FFT2048 or BASS_DATA_FFT_NOWINDOW);
if _IndexMin*_IndexMax=0 then
    begin
      if _Index<>0 then
       begin
        _hi_OnEvent(_event_onIndFreq, _Index);
        _hi_OnEvent(_event_onAmpl, FFTData[_Index]);       
       end;
    end
   else
    begin
      if _IndexMin>_IndexMax then
       begin
        _Index:=_IndexMin;
        _IndexMin:=_IndexMax;
        _IndexMax:=_Index;
       end;
      if _IndexMax>743 then _IndexMax:=743;
      if _IndexMin<1 then _IndexMin:=1;    
      for i := _IndexMin to _IndexMax do
       begin
        _hi_OnEvent(_event_onIndFreq, i);
        _hi_OnEvent(_event_onAmpl, FFTData[i]);
       end;
    end; 
end;

procedure THIBASS_FFT_2048_Vis._work_doStrFreqSeparation;
var i,j:integer;
    _Str,_Char,_S:string;
begin
  _Str:= ToString(_Data);  
    if _Str='' then _Str:='1;3;5;10;20;30;50;100;150;200;300';
  _S:='';
  _Count:=0;    
   for i:=1 to length(_Str) do
    begin
     _Char:=_Str[i]; 
      if ((_Char=';') and (_S<>''))  then
       begin
        FreqSeparation[_Count]:=str2int(_S);
        _S:='';
         if FreqSeparation[_Count]>743 then FreqSeparation[_Count]:=743;
         if FreqSeparation[_Count]<1 then FreqSeparation[_Count]:=1;
        _Count:=_Count+1;
       end
      else _S:=_S+_Char;
    end;  
      if _S<>'' then
       begin
        FreqSeparation[_Count]:=str2int(_S);
        _S:='';
         if FreqSeparation[_Count]>743 then FreqSeparation[_Count]:=743;
         if FreqSeparation[_Count]<1 then FreqSeparation[_Count]:=1;       
       end;
end;

procedure THIBASS_FFT_2048_Vis._work_doFftVis;
var i,j:integer;
    h:cardinal;
    FFTData:TFFTData;
    _Sum:double;
begin
  h := _prop_SoundStream^;
   if BASS_ChannelIsActive(h) <> BASS_ACTIVE_PLAYING then Exit;
  BASS_ChannelGetData(h, @FFTData, BASS_DATA_FFT2048 or BASS_DATA_FFT_NOWINDOW);
   for i:=0 to _Count-2 do
    begin
     _Sum:=0;
      for j:=FreqSeparation[i] to FreqSeparation[i+1]-1 do _Sum:=_Sum+FFTData[j];
     _hi_OnEvent(_event_onIndFreq, i);
     _hi_OnEvent(_event_onAmpl, _Sum);       
    end;
end;

end.
