
;CodeVisionAVR C Compiler V2.03.9 Standard
;(C) Copyright 1998-2008 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type              : ATtiny13
;Clock frequency        : 9,600000 MHz
;Memory model           : Tiny
;Optimize for           : Size
;(s)printf features     : int, width
;(s)scanf features      : int, width
;External RAM size      : 0
;Data Stack size        : 16 byte(s)
;Heap size              : 0 byte(s)
;Promote char to int    : Yes
;char is unsigned       : Yes
;global const stored in FLASH  : No
;8 bit enums            : Yes
;Smart register allocation : Off
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATtiny13
	#pragma AVRPART MEMORY PROG_FLASH 1024
	#pragma AVRPART MEMORY EEPROM 64
	#pragma AVRPART MEMORY INT_SRAM SIZE 64
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.LISTMAC
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E

	.EQU WDTCR=0x21
	.EQU MCUSR=0x34
	.EQU MCUCR=0x35
	.EQU SPL=0x3D
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ANDI R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ORI  R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+@1)
	LDI  R31,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	LDI  R22,BYTE3(2*@0+@1)
	LDI  R23,BYTE4(2*@0+@1)
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+@2)
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+@3)
	LDI  R@1,HIGH(@2+@3)
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+@3)
	LDI  R@1,HIGH(@2*2+@3)
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+@1
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+@1
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	LDS  R22,@0+@1+2
	LDS  R23,@0+@1+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+@2
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+@3
	LDS  R@1,@2+@3+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+@1
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	LDS  R24,@0+@1+2
	LDS  R25,@0+@1+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+@1,R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	STS  @0+@1+2,R22
	STS  @0+@1+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	RCALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	RCALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	RCALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+@1,R0
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+@1,R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+@1,R@2
	STS  @0+@1+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	RCALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	RCALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOV  R26,R@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __GETB1SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOV  R30,R0
	MOV  R31,R1
	.ENDM

	.MACRO __GETB2SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOV  R26,R0
	MOV  R27,R1
	.ENDM

	.MACRO __GETBRSX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __LSLW8SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R@1
	.ENDM

	.MACRO __PUTWSRX
	MOV  R30,R28
	MOV  R31,R29
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOV  R26,R28
	MOV  R27,R29
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _Rx_Count=R11
	.DEF _Rx_Byte=R12
	.DEF _Tx_Count=R13
	.DEF _Tx_Byte=R14

	.CSEG
	.ORG 0x00

;INTERRUPT VECTORS
	RJMP __RESET
	RJMP 0x00
	RJMP _pin_change_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP _timer0_compa_isr
	RJMP _timer0_compb_isr
	RJMP 0x00
	RJMP 0x00

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	IN   R26,MCUSR
	CBR  R26,8
	OUT  MCUSR,R26
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x40)
	LDI  R26,0x60
__CLEAR_SRAM:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_SRAM

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x9F)
	OUT  SPL,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0x70)
	LDI  R29,HIGH(0x70)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x70

	.CSEG
;/*****************************************************
;This program was produced by the
;CodeWizardAVR V2.03.9 Standard
;
;Project : ProgUART
;Version :
;Date    : 23.06.2010
;Author  : www.GetChip.net
;Company : Home
;Comments:
;
;Chip type               : ATtiny13
;AVR Core Clock frequency: 9,600000 MHz
;Memory model            : Tiny
;External RAM size       : 0
;Data Stack size         : 16
;
;TxD -  2 - 
;RxD -  3 - 
;*****************************************************/
;
;#include <tiny13.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x18
	.EQU __sm_adc_noise_red=0x08
	.EQU __sm_powerdown=0x10
	.SET power_ctrl_reg=mcucr
	#endif
;
;#define f_clk                      9600000     //   
;#define N                           8          //  Timer0
;#define Baund_Rate  9600
;//   UART ( -   -
;//    /  5%)
;#define Bit_Width (f_clk/(N*Baund_Rate)-1)     //   OCR0A
;#define Half_Bit_Width (Bit_Width/2)           //    OCR0B
;#define RxD PinB4                              //  
;#define TxD PortB.3                            //  
;
;// Declare your global variables here
;register unsigned char Rx_Count @11;
;register unsigned char Rx_Byte @12;
;register unsigned char Tx_Count @13;
;register unsigned char Tx_Byte @14;
;
;
;
;// Pin change interrupt service routine
;interrupt [PCINT0] void pin_change_isr(void)
; 0000 002C {

	.CSEG
_pin_change_isr:
; 0000 002D //  -,   
; 0000 002E 
; 0000 002F      #asm
; 0000 0030 

; 0000 0031 	    push	r16
	    push	r16
; 0000 0032 	    in	    r16,0x3F
	    in	    r16,0x3F
; 0000 0033 	    push	r16
	    push	r16
; 0000 0034 	    ldi	    r16,0x00
	    ldi	    r16,0x00
; 0000 0035 	    out	    0x3B,r16
	    out	    0x3B,r16
; 0000 0036 	    in	    r16,0x32
	    in	    r16,0x32
; 0000 0037 	    subi	r16,0xC2   ;  1 Half_Bit_Width
	    subi	r16,0xC2   ;  1 Half_Bit_Width
; 0000 0038 	    cpi	    r16,0x7C   ;Bit_Width
	    cpi	    r16,0x7C   ;Bit_Width
; 0000 0039 	    brcs	LI000A
	    brcs	LI000A
; 0000 003A 

; 0000 003B 	    subi	r16,0x7C   ;Bit_Width
	    subi	r16,0x7C   ;Bit_Width
; 0000 003C LI000A:
LI000A:
; 0000 003D 	    out	    0x29,r16
	    out	    0x29,r16
; 0000 003E 	    ldi	    r16,0x00
	    ldi	    r16,0x00
; 0000 003F 	    mov	    r11,r16
	    mov	    r11,r16
; 0000 0040 	    pop	    r16
	    pop	    r16
; 0000 0041 	    out	    0x3F,r16
	    out	    0x3F,r16
; 0000 0042 	    pop	    r16
	    pop	    r16
; 0000 0043 

; 0000 0044       #endasm
; 0000 0045 
; 0000 0046 }
	RETI
;
;// Timer 0 output compare A interrupt service routine
;interrupt [TIM0_COMPA] void timer0_compa_isr(void)
; 0000 004A {
_timer0_compa_isr:
; 0000 004B //   
; 0000 004C       #asm
; 0000 004D 

; 0000 004E 	    push	r16
	    push	r16
; 0000 004F 	    push	r17
	    push	r17
; 0000 0050 	    in	    r16,0x3F
	    in	    r16,0x3F
; 0000 0051 	    push	r16
	    push	r16
; 0000 0052 	    ldi	    r17,0x0A
	    ldi	    r17,0x0A
; 0000 0053 	    cp	    r13,r17
	    cp	    r13,r17
; 0000 0054 	    brcc	LA0013
	    brcc	LA0013
; 0000 0055 

; 0000 0056 	    ldi	    r17,0x00
	    ldi	    r17,0x00
; 0000 0057 	    cp	    r13,r17
	    cp	    r13,r17
; 0000 0058 	    brne	LA000C
	    brne	LA000C
; 0000 0059 

; 0000 005A 	    cbi	    0x18,0x3
	    cbi	    0x18,0x3
; 0000 005B 	    rjmp	LA0012
	    rjmp	LA0012
; 0000 005C 

; 0000 005D LA000C:
LA000C:
; 0000 005E 	    bst	    r14,0x0
	    bst	    r14,0x0
; 0000 005F 	    in	    r16,0x18
	    in	    r16,0x18
; 0000 0060 	    bld	    r16,0x3
	    bld	    r16,0x3
; 0000 0061 	    out	    0x18,r16
	    out	    0x18,r16
; 0000 0062 	    sec
	    sec
; 0000 0063 	    ror	    r14
	    ror	    r14
; 0000 0064 LA0012:
LA0012:
; 0000 0065 	    inc	    r13
	    inc	    r13
; 0000 0066 LA0013:
LA0013:
; 0000 0067 	    pop	    r16
	    pop	    r16
; 0000 0068 	    out	    0x3F,r16
	    out	    0x3F,r16
; 0000 0069 	    pop	    r17
	    pop	    r17
; 0000 006A 	    pop	    r16
	    pop	    r16
; 0000 006B 

; 0000 006C     #endasm
; 0000 006D 
; 0000 006E }
	RETI
;
;// Timer 0 output compare B interrupt service routine
;interrupt [TIM0_COMPB] void timer0_compb_isr(void)
; 0000 0072 {
_timer0_compb_isr:
; 0000 0073 //      RxD
; 0000 0074       #asm
; 0000 0075 	    push	r16
	    push	r16
; 0000 0076 	    push	r17
	    push	r17
; 0000 0077 	    in	    r16,0x3F
	    in	    r16,0x3F
; 0000 0078 	    push	r16
	    push	r16
; 0000 0079 	    ldi	    r17,0x0A
	    ldi	    r17,0x0A
; 0000 007A 	    cp	    r11,r17
	    cp	    r11,r17
; 0000 007B 	    brcc	LB001E
	    brcc	LB001E
; 0000 007C 

; 0000 007D 	    ldi	    r17,0x00
	    ldi	    r17,0x00
; 0000 007E 	    cp	    r11,r17
	    cp	    r11,r17
; 0000 007F 	    brne	LB000C
	    brne	LB000C
; 0000 0080 

; 0000 0081 	    sbic	0x16,0x4
	    sbic	0x16,0x4
; 0000 0082 	    rjmp	LB0016
	    rjmp	LB0016
; 0000 0083 

; 0000 0084 LB000C:
LB000C:
; 0000 0085 	    ldi	    r16,0x08
	    ldi	    r16,0x08
; 0000 0086 	    cp	    r16,r11
	    cp	    r16,r11
; 0000 0087 	    brcs	LB0014
	    brcs	LB0014
; 0000 0088 

; 0000 0089 	    lsr	    r12
	    lsr	    r12
; 0000 008A 	    in	    r16,0x16
	    in	    r16,0x16
; 0000 008B 	    bst	    r16,0x4
	    bst	    r16,0x4
; 0000 008C 	    bld	    r12,0x7
	    bld	    r12,0x7
; 0000 008D 	    rjmp	LB001D
	    rjmp	LB001D
; 0000 008E 

; 0000 008F LB0014:
LB0014:
; 0000 0090 

; 0000 0091 	    sbic	0x16,0x4
	    sbic	0x16,0x4
; 0000 0092 	    rjmp	LB001A
	    rjmp	LB001A
; 0000 0093 

; 0000 0094 LB0016:
LB0016:
; 0000 0095 	    ldi	    r16,0x9E
	    ldi	    r16,0x9E
; 0000 0096 	    mov	    r12,r16
	    mov	    r12,r16
; 0000 0097 	    ldi	    r16,0x09
	    ldi	    r16,0x09
; 0000 0098 	    mov	    r11,r16
	    mov	    r11,r16
; 0000 0099 LB001A:
LB001A:
; 0000 009A 	    ldi	    r16,0x20
	    ldi	    r16,0x20
; 0000 009B 	    out	    0x3A,r16
	    out	    0x3A,r16
; 0000 009C 	    out	    0x3B,r16
	    out	    0x3B,r16
; 0000 009D LB001D:
LB001D:
; 0000 009E 	    inc	    r11
	    inc	    r11
; 0000 009F LB001E:
LB001E:
; 0000 00A0 	    pop	    r16
	    pop	    r16
; 0000 00A1 	    out	    0x3F,r16
	    out	    0x3F,r16
; 0000 00A2 	    pop	    r17
	    pop	    r17
; 0000 00A3 	    pop	    r16
	    pop	    r16
; 0000 00A4 

; 0000 00A5     #endasm
; 0000 00A6 }
	RETI
;
;
;void putbyte(unsigned char B)
; 0000 00AA {
_putbyte:
; 0000 00AB //     UART
; 0000 00AC //   TxD
; 0000 00AD while (Tx_Count < 10);        //       
;	B -> Y+0
_0x3:
	LDI  R30,LOW(10)
	CP   R13,R30
	BRLO _0x3
; 0000 00AE Tx_Byte = B;                  //  
	LDD  R14,Y+0
; 0000 00AF Tx_Count = 0;                //     UART
	CLR  R13
; 0000 00B0 }
	ADIW R28,1
	RET
;
;unsigned char getbyte(void)
; 0000 00B3 {
_getbyte:
; 0000 00B4 //     UART
; 0000 00B5 //   RxD
; 0000 00B6 if (Rx_Count == 11) return (157);  //     
	LDI  R30,LOW(11)
	CP   R30,R11
	BRNE _0x6
	LDI  R30,LOW(157)
	RET
; 0000 00B7 //   157 (   )
; 0000 00B8 while (Rx_Count < 10);     //     
_0x6:
_0x7:
	LDI  R30,LOW(10)
	CP   R11,R30
	BRLO _0x7
; 0000 00B9 Rx_Count = 11;              //  "" 
	LDI  R30,LOW(11)
	MOV  R11,R30
; 0000 00BA return (Rx_Byte);           //  
	MOV  R30,R12
	RET
; 0000 00BB }
;
;
;
;
;void main(void)
; 0000 00C1 {
_main:
; 0000 00C2 // Declare your local variables here
; 0000 00C3 unsigned char R_byte;
; 0000 00C4 
; 0000 00C5 // Crystal Oscillator division factor: 1
; 0000 00C6 #pragma optsize-
; 0000 00C7 CLKPR=0x80;
;	R_byte -> R16
	LDI  R30,LOW(128)
	OUT  0x26,R30
; 0000 00C8 CLKPR=0x00;
	LDI  R30,LOW(0)
	OUT  0x26,R30
; 0000 00C9 #ifdef _OPTIMIZE_SIZE_
; 0000 00CA #pragma optsize+
; 0000 00CB #endif
; 0000 00CC 
; 0000 00CD // Input/Output Ports initialization
; 0000 00CE // Port B initialization
; 0000 00CF // Func5=In Func4=In Func3=Out Func2=In Func1=In Func0=In
; 0000 00D0 // State5=T State4=P State3=1 State2=T State1=T State0=T
; 0000 00D1 // PORTB=0x18;
; 0000 00D2 // DDRB=0x08;
; 0000 00D3 DDRB.3=1;
	SBI  0x17,3
; 0000 00D4 PORTB.3=1;
	SBI  0x18,3
; 0000 00D5 PORTB.4=1;
	SBI  0x18,4
; 0000 00D6 
; 0000 00D7 // Timer/Counter 0 initialization
; 0000 00D8 // Clock source: System Clock
; 0000 00D9 // Clock value: 1200,000 kHz
; 0000 00DA // Mode: CTC top=OCR0A
; 0000 00DB // OC0A output: Disconnected
; 0000 00DC // OC0B output: Disconnected
; 0000 00DD TCCR0A=0x02;
	LDI  R30,LOW(2)
	OUT  0x2F,R30
; 0000 00DE TCCR0B=0x02;
	OUT  0x33,R30
; 0000 00DF TCNT0=0x00;
	LDI  R30,LOW(0)
	OUT  0x32,R30
; 0000 00E0 
; 0000 00E1 OCR0A=Bit_Width;
	LDI  R30,LOW(124)
	OUT  0x36,R30
; 0000 00E2 OCR0B=0x00;
	LDI  R30,LOW(0)
	OUT  0x29,R30
; 0000 00E3 
; 0000 00E4 // External Interrupt(s) initialization
; 0000 00E5 // INT0: Off
; 0000 00E6 // Interrupt on any change on pins PCINT0-5: On
; 0000 00E7 GIMSK=0x20;
	LDI  R30,LOW(32)
	OUT  0x3B,R30
; 0000 00E8 MCUCR=0x00;
	LDI  R30,LOW(0)
	OUT  0x35,R30
; 0000 00E9 PCMSK=0x10;
	LDI  R30,LOW(16)
	OUT  0x15,R30
; 0000 00EA GIFR=0x20;
	LDI  R30,LOW(32)
	OUT  0x3A,R30
; 0000 00EB 
; 0000 00EC // Timer/Counter 0 Interrupt(s) initialization
; 0000 00ED TIMSK0=0x0C;
	LDI  R30,LOW(12)
	OUT  0x39,R30
; 0000 00EE 
; 0000 00EF //  
; 0000 00F0 Tx_Count=11;   //  
	LDI  R30,LOW(11)
	MOV  R13,R30
; 0000 00F1 Rx_Count=11;   //  
	MOV  R11,R30
; 0000 00F2 
; 0000 00F3 // Global enable interrupts
; 0000 00F4 #asm("sei")
	sei
; 0000 00F5 
; 0000 00F6 while (1)
_0x10:
; 0000 00F7       {
; 0000 00F8       R_byte=getbyte();     //    UART
	RCALL _getbyte
	MOV  R16,R30
; 0000 00F9       if ((R_byte!=157) & (R_byte!=158))     //       - 
	MOV  R26,R16
	LDI  R30,LOW(157)
	RCALL __NEB12
	MOV  R0,R30
	LDI  R30,LOW(158)
	RCALL __NEB12
	AND  R30,R0
	BREQ _0x13
; 0000 00FA         {//       
; 0000 00FB         if ((R_byte > 0x60) & (R_byte < 0x7B))
	LDI  R30,LOW(96)
	RCALL __GTB12U
	MOV  R0,R30
	LDI  R30,LOW(123)
	RCALL __LTB12U
	AND  R30,R0
	BREQ _0x14
; 0000 00FC         putbyte(R_byte-32);
	LDI  R27,0
	LDI  R30,LOW(32)
	LDI  R31,HIGH(32)
	RCALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	ST   -Y,R30
	RJMP _0x17
; 0000 00FD         else putbyte(R_byte);
_0x14:
	ST   -Y,R16
_0x17:
	RCALL _putbyte
; 0000 00FE         };
_0x13:
; 0000 00FF       };
	RJMP _0x10
; 0000 0100 }
_0x16:
	RJMP _0x16

	.CSEG

	.CSEG
__NEB12:
	CP   R30,R26
	LDI  R30,1
	BRNE __NEB12T
	CLR  R30
__NEB12T:
	RET

__LTB12U:
	CP   R26,R30
	LDI  R30,1
	BRLO __LTB12U1
	CLR  R30
__LTB12U1:
	RET

__GTB12U:
	CP   R30,R26
	LDI  R30,1
	BRLO __GTB12U1
	CLR  R30
__GTB12U1:
	RET

__SWAPW12:
	MOV  R1,R27
	MOV  R27,R31
	MOV  R31,R1

__SWAPB12:
	MOV  R1,R26
	MOV  R26,R30
	MOV  R30,R1
	RET

;END OF CODE MARKER
__END_OF_CODE:
