
#pragma used+
sfrb ADCSRB=0x03;
sfrb ADCL=0x04;
sfrb ADCH=0x05;
sfrw ADCW=0x04; 
sfrb ADCSRA=0x06;
sfrb ADMUX=0x07;
sfrb ACSR=0x08;
sfrb DIDR0=0x14;
sfrb PCMSK=0x15;
sfrb PINB=0x16;
sfrb DDRB=0x17;
sfrb PORTB=0x18;
sfrb EECR=0x1c;
sfrb EEDR=0x1d;
sfrb EEAR=0x1e;
sfrb WDTCR=0x21;
sfrb CLKPR=0x26;
sfrb GTCCR=0x28;
sfrb OCR0B=0x29;
sfrb DWDR=0x2e;
sfrb TCCR0A=0x2f;
sfrb OSCCAL=0x31;
sfrb TCNT0=0x32;
sfrb TCCR0B=0x33;
sfrb MCUSR=0x34;
sfrb MCUCR=0x35;
sfrb OCR0A=0x36;
sfrb SPMCSR=0x37;
sfrb TIFR0=0x38;
sfrb TIMSK0=0x39;
sfrb GIFR=0x3a;
sfrb GIMSK=0x3b;
sfrb SPL=0x3d;
sfrb SREG=0x3f;
#pragma used-

#asm
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x18
	.EQU __sm_adc_noise_red=0x08
	.EQU __sm_powerdown=0x10
	.SET power_ctrl_reg=mcucr
	#endif
#endasm

register unsigned char Rx_Count @11;
register unsigned char Rx_Byte @12;
register unsigned char Tx_Count @13;
register unsigned char Tx_Byte @14;

interrupt [3] void pin_change_isr(void)
{

#asm

	    push	r16
	    in	    r16,0x3F
	    push	r16
	    ldi	    r16,0x00
	    out	    0x3B,r16
	    in	    r16,0x32
	    subi	r16,0xC2   ;  1 Half_Bit_Width
	    cpi	    r16,0x7C   ;Bit_Width
	    brcs	LI000A
 
	    subi	r16,0x7C   ;Bit_Width
LI000A:
	    out	    0x29,r16
	    ldi	    r16,0x00
	    mov	    r11,r16
	    pop	    r16
	    out	    0x3F,r16
	    pop	    r16

      #endasm 

}

interrupt [7] void timer0_compa_isr(void)
{

#asm

	    push	r16
	    push	r17
	    in	    r16,0x3F
	    push	r16
	    ldi	    r17,0x0A
	    cp	    r13,r17
	    brcc	LA0013
 
	    ldi	    r17,0x00
	    cp	    r13,r17
	    brne	LA000C
 
	    cbi	    0x18,0x3
	    rjmp	LA0012
 
LA000C:
	    bst	    r14,0x0
	    in	    r16,0x18
	    bld	    r16,0x3
	    out	    0x18,r16
	    sec
	    ror	    r14
LA0012:
	    inc	    r13
LA0013:
	    pop	    r16
	    out	    0x3F,r16
	    pop	    r17
	    pop	    r16
    
    #endasm

}

interrupt [8] void timer0_compb_isr(void)
{

#asm
	    push	r16
	    push	r17
	    in	    r16,0x3F
	    push	r16
	    ldi	    r17,0x0A
	    cp	    r11,r17
	    brcc	LB001E
 
	    ldi	    r17,0x00
	    cp	    r11,r17
	    brne	LB000C
 
	    sbic	0x16,0x4
	    rjmp	LB0016
 
LB000C:
	    ldi	    r16,0x08
	    cp	    r16,r11
	    brcs	LB0014
 
	    lsr	    r12
	    in	    r16,0x16
	    bst	    r16,0x4
	    bld	    r12,0x7
	    rjmp	LB001D
 
LB0014:
 
	    sbic	0x16,0x4
	    rjmp	LB001A
 
LB0016:
	    ldi	    r16,0x9E
	    mov	    r12,r16
	    ldi	    r16,0x09
	    mov	    r11,r16
LB001A:
	    ldi	    r16,0x20
	    out	    0x3A,r16
	    out	    0x3B,r16
LB001D:
	    inc	    r11
LB001E:
	    pop	    r16
	    out	    0x3F,r16
	    pop	    r17
	    pop	    r16
	  
    #endasm
}

void putbyte(unsigned char B)
{

while (Tx_Count < 10);        
Tx_Byte = B;                  
Tx_Count = 0;                
}

unsigned char getbyte(void)
{

if (Rx_Count == 11) return (157);  

while (Rx_Count < 10);     
Rx_Count = 11;              
return (Rx_Byte);           
}

void main(void)
{

unsigned char R_byte;

#pragma optsize-
CLKPR=0x80;
CLKPR=0x00;
#pragma optsize+

DDRB.3=1;
PORTB.3=1;
PORTB.4=1;

TCCR0A=0x02;
TCCR0B=0x02;
TCNT0=0x00;

OCR0A=(9600000     /(8          *9600)-1)     ;
OCR0B=0x00;

GIMSK=0x20;
MCUCR=0x00;
PCMSK=0x10;
GIFR=0x20;

TIMSK0=0x0C;

Tx_Count=11;   
Rx_Count=11;   

#asm("sei")

while (1)
{
R_byte=getbyte();     
if ((R_byte!=157) & (R_byte!=158))     
{
if ((R_byte > 0x60) & (R_byte < 0x7B))
putbyte(R_byte-32);
else putbyte(R_byte);
};
};
}
