/*****************************************************
   UART
http://www.GetChip.net

Chip type           : ATtiny2313
Clock frequency     : 8,000000 MHz
Memory model        : Tiny
External SRAM size  : 0
Data Stack size     : 32
*****************************************************/

#include <tiny2313.h>

#define RXB8 1
#define TXB8 0
#define UPE 2
#define OVR 3
#define FE 4
#define UDRE 5
#define RXC 7

#define FRAMING_ERROR (1<<FE)
#define PARITY_ERROR (1<<UPE)
#define DATA_OVERRUN (1<<OVR)
#define DATA_REGISTER_EMPTY (1<<UDRE)
#define RX_COMPLETE (1<<RXC)

//   -    
//  FromGCnDevice==0 -   
char FromGCnDevice;

//     
interrupt [USART_RXC] void usart_rx_isr(void)
{
char status;
//     
status=UCSRA;
FromGCnDevice=UDR; 
//        FromGCnDevice=0 
if ((status & (FRAMING_ERROR | PARITY_ERROR | DATA_OVERRUN))!=0)FromGCnDevice=0;
}

//   
void ToGCnDevice (char c)
{
//     
while ((UCSRA & DATA_REGISTER_EMPTY)==0); 
//  
UDR=c;
}

// Standard Input/Output functions
#include <stdio.h>

// Declare your global variables here

void main(void)
{
// Declare your local variables here

// USART initialization
// Communication Parameters: 8 Data, 1 Stop, Even Parity
// USART Receiver: On
// USART Transmitter: On
// USART Mode: Asynchronous
// USART Baud Rate: 9600
UCSRA=0x00;
UCSRB=0x98;
UCSRC=0x26;
UBRRH=0x00;
UBRRL=0x33;

// Global enable interrupts
#asm("sei")

while (1)
      {
      // Place your code here

      };
}
